---
type: constant
tags:
  - "#layer/implementation"
  - "#status/stable"
  - "#function/definition"
aliases:
  - φ
  - Phi
  - Golden Ratio
---

# φ — Golden Ratio (constant)

> Mathematical implementation of asymmetric stabilization ratio.
> See [[φ — Asymmetric Stabilization Ratio (constant)]] for core conceptual meaning.

---

## Definition

- Symbol: φ
- Value: 1.618033988749895... (dimensionless)
- Primary: Ratio where (a+b)/a = a/b
- Precision: Double precision (≈1e-15) typically sufficient

---

## Dual‑register mapping

Map the implementation into both registers while preserving core meaning.

### Technical (mathematical)

| Implementation | Mathematical construct | Code example |
|----------------|----------------------|--------------|
| Value | Algebraic number | `(1 + sqrt(5))/2` |
| Series | Fibonacci ratio | `F(n+1)/F(n)` |
| Equation | Quadratic solution | `x^2 = x + 1` |

### Humane (experiential)

| Implementation | Natural example | Experience |
|----------------|----------------|------------|
| Value | Natural proportion | Pleasant balance |
| Series | Growth pattern | Organic expansion |
| Equation | Self-similarity | Nested harmony |

### Crosswalk (bridge)

| Math term | Natural term | Implementation meaning |
|-----------|-------------|----------------------|
| Ratio | Balance | How parts relate |
| Series | Pattern | How to compute |
| Equation | Harmony | How to define |

---

## Implementation Details

### Primary Formulas

1. **Algebraic form**
   $$\phi = \frac{1 + \sqrt{5}}{2}$$
   (solution to $x^2 = x + 1$)

2. **Fibonacci limit**
   $$\phi = \lim_{n \to \infty} \frac{F_{n+1}}{F_n}$$
   (ratio of consecutive terms)

3. **Continued fraction**
   $$\phi = 1 + \cfrac{1}{1 + \cfrac{1}{1 + \cfrac{1}{1 + \cdots}}}$$
   (simplest continued fraction)

### Usage Guidelines

1. **Precision**
   - Compute from algebraic form
   - Double precision sufficient
   - Specify precision needs explicitly

2. **Performance**
   - Cache φ value, don't recompute
   - Use algebraic form for accuracy
   - Consider lookup tables for speed

3. **Validation**
   - Test against known decimals
   - Verify ratio properties
   - Check Fibonacci convergence

---

## Scope & Constraints

- Algebraic number (not transcendental)
- Appears in Fibonacci growth
- Computational approximations sufficient

---

## Design rationale

This implementation maintains dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../../PRINCIPLES.md)). Mathematical precision is balanced with natural understanding.

---

## See Also

- [[φ — Asymmetric Stabilization Ratio (constant)]] (core concept)
- [[π — Circle Constant (constant)]] · [[e — Euler's Number (constant)]]
- [[10.1 - Formalization (Math) (index)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included